Option Explicit
Const scriptName = "Border in Black"
Const scriptVer = "1.0.1"

' Revision History

' 1.0.1 - December 13, 2002 - MJM - Updated for 6.5.2, fixing the Send command.
' 1.0.0 - July 26, 2002 - MJM - Inital version.



' Script constants, questions, and error messages.
Const errNoSelection = "This script requires a single selected element."


' Enums
' enum crScaleMethod
Const crNoScaling = -2074909844
Const crFitContainer = -2074922426
Const crFitWithinContainer = -2075764925
Const crFillContainer = -2075770001

' enum crLocation
Const crBeforeAll = 1650945639
Const crAfterAll = 1701733408
Const crBefore = 1650812527
Const crAfter = 1634104421




' Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errNoSelection, vbOkonly, scriptName)
  errNum = -1
End If

Dim sel
If errNum = 0 Then
  On Error Resume Next

  Set sel = CreatorApp.Selection
  errNum = Err.Number
  On Error GoTo 0
  
  If errNum <> 0 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
  Elseif (sel.Count <> 1) Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  End If
End If

If errNum = 0 Then
  Dim someElem, itsBounds, frameElem
  Set someElem = sel(1)
  itsBounds = someElem.Bounds
  Set frameElem = someElem.Parent.Elements.AddRectangleElement(itsBounds, crNoScaling, crBefore, someElem)
  frameElem.Rotation = someElem.Rotation
  frameElem.SkewAngle = someElem.SkewAngle
  Call someElem.Send(False, True, crNoScaling, crBeforeAll, frameElem)
  frameElem.Select
End If

